/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamImageSink
extends AbstractImageSink<OutputStream> {
    private final OutputStream os;

    public OutputStreamImageSink(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        this.os = outputStream;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        List<String> list2;
        super.write(bufferedImage);
        if (this.outputFormat == null) {
            throw new IllegalStateException("Output format has not been set.");
        }
        String string2 = this.outputFormat;
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName(string2);
        if (!iterator2.hasNext()) {
            throw new UnsupportedFormatException(string2, "No suitable ImageWriter found for " + string2 + ".");
        }
        ImageWriter imageWriter = iterator2.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed() && this.param != null) {
            imageWriteParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                imageWriteParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                list2 = ThumbnailatorUtils.getSupportedOutputFormatTypes(string2);
                if (!list2.isEmpty()) {
                    imageWriteParam.setCompressionType((String)list2.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                imageWriteParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        if ((list2 = ImageIO.createImageOutputStream(this.os)) == null) {
            throw new IOException("Could not open OutputStream.");
        }
        if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("bmp")) {
            bufferedImage = BufferedImages.copy(bufferedImage, 1);
        }
        imageWriter.setOutput(list2);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        list2.close();
    }

    @Override
    public OutputStream getSink() {
        return this.os;
    }
}

